#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "attribute.h"
#include "routine.h"
#include "routine_composite.h"
#include "evolve.h"


char *opt_symbol(long opt_type)
{
switch(opt_type){
	case OPT_ADD: return "+";
	case OPT_SUB: return "-";
	case OPT_MUL: return "*";
	case OPT_DIV: return "/";
	case OPT_LT: return "<";
	case OPT_GT: return ">";
	case OPT_LE: return "<=";
	case OPT_GE: return ">=";
	case OPT_AND: return "and";
	case OPT_OR: return "or";
	case OPT_UN: return "union";
	case OPT_IN: return "intersect";
	case OPT_EQL: return "==";
	default:
		return "op";
	}
}

void dump_operation(FILE *fout, OPT *o)
{
if(o==NULL){
	fprintf(fout,"null");
	return;
	}
switch(o->type){
	case OPT_ADD:
	case OPT_SUB:
	case OPT_MUL:
	case OPT_DIV:
	case OPT_LT:
	case OPT_GT:
	case OPT_LE:
	case OPT_GE:
	case OPT_AND:
	case OPT_OR:
	case OPT_UN:
	case OPT_IN:
	case OPT_EQL:
		fprintf(fout,"(");
		dump_operation(fout,o->param1);
		fprintf(fout,")%s(",opt_symbol(o->type));
		dump_operation(fout,o->param2);
		fprintf(fout,")");
		break;
	case OPT_CI:
		fprintf(fout,"%lld",o->value);
		break;
	case OPT_AT:
		fprintf(fout,"[%s]",get_attribute_name(o->value));
		break;
	case OPT_FN:
		fprintf(fout,"{%s}",get_routine_name(o->value));
		break;
	case OPT_IF:
		fprintf(fout,"(");
		dump_operation(fout,o->param1);
		fprintf(fout,") ? (");
		dump_operation(fout,o->param2);
		fprintf(fout,") : (");
		dump_operation(fout,o->param3);
		fprintf(fout,")");
		break;
		
	default:
		fprintf(fout,"abstract%d",o->type);
	}
	
}

int evaluate_operation(OPT *o,u64 *result)
{
u64 a,b;
if(o==NULL){
	return -1;
	}
switch(o->type){
	case OPT_ADD:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a+b;
		break;
	case OPT_SUB:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a-b;
		break;
	case OPT_MUL:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a*b;
		break;
	case OPT_DIV:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		if(!b)return -1;
		*result=a/b;
		break;
	case OPT_LT:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a<b;
		break;
	case OPT_LE:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a<=b;
		break;
	case OPT_GT:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=a>b;
		break;
	case OPT_GE:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=(a>=b);
		break;
	case OPT_EQL:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(evaluate_operation(o->param2,&b)<0)return -1;
		*result=(a==b);
		break;
	case OPT_CI:
		*result=o->value;
		break;
	case OPT_AT:
		return evaluate_attribute(o->value,result);
		break;
	case OPT_FN:
		return evaluate_routine(o->value,result);
		break;
	case OPT_IF:
		if(evaluate_operation(o->param1,&a)<0)return -1;
		if(a){
			if(evaluate_operation(o->param2,result)<0)return -1;
		     } else {
			if(evaluate_operation(o->param3,result)<0)return -1;
			}
		return 0;
	default:
		return -1;
	}
return 0;	
}

int execute_composite(ROUTINE *r,u64 *param,void *data, u64 *result)
{
if(data==NULL)return -1;
return evaluate_operation((OPT *)data,result);
}

